VERSION 5.00
Object = "{30946493-A18B-4E31-BD79-97E0026DC33C}#3.0#0"; "MegaGrid.ocx"
Begin VB.Form frmGrid 
   Caption         =   "MegaGrid Demo"
   ClientHeight    =   7485
   ClientLeft      =   120
   ClientTop       =   465
   ClientWidth     =   9330
   LinkTopic       =   "Form1"
   ScaleHeight     =   7485
   ScaleWidth      =   9330
   StartUpPosition =   2  'CenterScreen
   Begin MegaGrid.MegaGridCtrl MegaGridCtrl 
      Height          =   3975
      Left            =   240
      TabIndex        =   7
      Top             =   2160
      Width           =   8655
      Object.Visible         =   -1  'True
      AutoScroll      =   0   'False
      AutoSize        =   0   'False
      AxBorderStyle   =   0
      Caption         =   "MegaGridCtrl"
      BackColor       =   16777215
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      KeyPreview      =   0   'False
      PixelsPerInch   =   96
      PrintScale      =   1
      Scaled          =   -1  'True
      DropTarget      =   0   'False
      HelpFile        =   ""
      DoubleBuffered  =   0   'False
      Enabled         =   -1  'True
      Cursor          =   0
      HelpType        =   0
      HelpKeyword     =   ""
      FixedColor      =   10789024
      FixedColumns    =   0
      FixedRows       =   1
      RowsCount       =   10
      ColumnsCount    =   4
      DefaultRowHeight=   36
      DefaultColumnWidth=   64
      ResizingColumn  =   -1  'True
      ResizingRow     =   -1  'True
      MovingColumn    =   0   'False
      GridLineWidth   =   1
      CheckBoxColor   =   0
      CheckHalfColor  =   13158600
      SelectedBackColor=   16711680
      SelectedTextColor=   16777215
      ZebraColor      =   14474460
      ArrowColor      =   32768
      CheckBoxSize    =   14
      AllowCheckBox   =   -1  'True
      CheckThickLine  =   -1  'True
      AllowZebras     =   -1  'True
      CheckBoxType    =   4
      SelectFirstRowAfterSorting=   -1  'True
      DefaultCheckAll =   -1  'True
      LicenseCode     =   "TrialVersion"
      LinkColor       =   255
      UnderlinedLink  =   0   'False
      TruncateText    =   -1  'True
      ForeColor       =   0
   End
   Begin VB.CommandButton btnSelectTag 
      Caption         =   "Get Index and Tag for Selected Row"
      Height          =   500
      Left            =   4440
      TabIndex        =   6
      Top             =   1200
      Width           =   4575
   End
   Begin VB.CommandButton btnAllTags 
      Caption         =   "Get Tags for Checked Rows"
      Height          =   500
      Left            =   4440
      TabIndex        =   5
      Top             =   360
      Width           =   4575
   End
   Begin VB.Frame frmOptions 
      Caption         =   "Options"
      Height          =   1815
      Left            =   240
      TabIndex        =   1
      Top             =   120
      Width           =   3015
      Begin VB.CheckBox chkThickCheckLine 
         Alignment       =   1  'Right Justify
         Caption         =   "Thick Check Line"
         Height          =   375
         Left            =   360
         TabIndex        =   4
         Top             =   840
         Value           =   1  'Checked
         Width           =   2295
      End
      Begin VB.CheckBox chkShadeRows 
         Alignment       =   1  'Right Justify
         Caption         =   "Shade Alternate Rows"
         Height          =   375
         Left            =   360
         TabIndex        =   3
         Top             =   1320
         Value           =   1  'Checked
         Width           =   2295
      End
      Begin VB.CheckBox chkShowCheckBox 
         Alignment       =   1  'Right Justify
         Caption         =   "Show CheckBox"
         Height          =   375
         Left            =   360
         TabIndex        =   2
         Top             =   360
         Value           =   1  'Checked
         Width           =   2295
      End
   End
   Begin VB.CommandButton btnClose 
      Caption         =   "Close"
      Height          =   500
      Left            =   3960
      TabIndex        =   0
      Top             =   6600
      Width           =   1695
   End
End
Attribute VB_Name = "frmGrid"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Type Column
    Width       As Integer
    Title       As String
    Alignment   As Integer  '0 - Left, 1 - Center, 2 - Right
End Type

Private Type Cell
    Text        As String
End Type

Private Type Row
    IsChecked       As Boolean
    CellsArray()    As Cell
End Type

Private Type StateProv
    NickName As String
    Capital As String
End Type

Private ColumnsArray() As Column
Private RowsArray() As Row

Private Sub Form_Load()
    Call PopulateData
End Sub

Private Sub btnClose_Click()
    Unload Me
End Sub

Private Sub btnAllTags_Click()
    Dim Count As Integer
    Dim Tags As String
    Dim I As Integer
    
    Count = MegaGridCtrl.GetCheckedRowsCount
    Tags = ""
    For I = 0 To (Count - 1)
        If (I = 0) Then
            Tags = CStr(MegaGridCtrl.GetCheckedRowTagAt(I))
        Else
            Tags = Tags & "|" & CStr(MegaGridCtrl.GetCheckedRowTagAt(I))
        End If
    Next I
    
    MsgBox (Tags)
End Sub

Private Sub btnSelectTag_Click()
    Dim lTag As Long
    
    MsgBox ("Selected Row Index:" + CStr(MegaGridCtrl.GetSelectedRowIndex()) + vbCrLf + "Row Tag:" + CStr(MegaGridCtrl.GetSelectedRowTag()))
End Sub

Private Sub chkShadeRows_Click()
    If (chkShadeRows.Value = vbChecked) Then
        MegaGridCtrl.AllowZebras = True
    Else
        MegaGridCtrl.AllowZebras = False
    End If
End Sub

Private Sub chkShowCheckBox_Click()
    If (chkShowCheckBox.Value = vbChecked) Then
        MegaGridCtrl.AllowCheckBox = True
        chkThickCheckLine.Enabled = True
        btnAllTags.Enabled = True
    Else
        MegaGridCtrl.AllowCheckBox = False
        btnAllTags.Enabled = False
        chkThickCheckLine.Enabled = False
    End If
End Sub

Private Sub chkThickCheckLine_Click()
    If (chkThickCheckLine = vbChecked) Then
        MegaGridCtrl.CheckThickLine = True
    Else
        MegaGridCtrl.CheckThickLine = False
    End If
End Sub

Private Sub PopulateData()
    Dim RowsCount As Integer
    Dim I As Integer
    Dim J As Integer
    Dim iFileNo As Integer
    Dim sFileText As String
    Dim ItemsArr() As String
    Dim ColWidthArr(5) As Integer
    Dim ColAlignArr(5) As Integer
    Dim StateProvArr(8) As Integer
    Dim IsLinkText_1 As Boolean
    Dim IsLinkText_2 As Boolean
    Dim CellColor As Long
    Dim TextColor As Long
    Dim Line_2 As String
    Dim Line_3 As String
    Dim Line_4 As String
    Dim Result As Boolean
    
    ColWidthArr(0) = 45
    ColWidthArr(1) = 80
    ColWidthArr(2) = 80
    ColWidthArr(3) = 95
    ColWidthArr(4) = 120
    ColWidthArr(5) = 100
    
    ColAlignArr(0) = 2
    ColAlignArr(1) = 1
    ColAlignArr(2) = 1
    ColAlignArr(3) = 1
    ColAlignArr(4) = 1
    ColAlignArr(5) = 0
    
    Open App.Path & "\Cities.txt" For Input As #1
    
    RowsCount = 0
    Do While Not EOF(1)
        Input #1, sFileText
        ItemsArr = Split(sFileText, "|")
        
        If (RowsCount = 0) Then
            'Header
            ReDim ColumnsArray(UBound(ItemsArr))
            For I = 0 To UBound(ItemsArr)
                ColumnsArray(I).Title = Trim(ItemsArr(I))
                ColumnsArray(I).Width = ColWidthArr(I)
                ColumnsArray(I).Alignment = ColAlignArr(I)
            Next I
            RowsCount = RowsCount + 1
        Else
            'Data
            ReDim Preserve RowsArray(RowsCount - 1)
            ReDim RowsArray(RowsCount - 1).CellsArray(UBound(ItemsArr))
            For I = 0 To UBound(ItemsArr)
                RowsArray(RowsCount - 1).CellsArray(I).Text = Trim(ItemsArr(I))
                RowsArray(RowsCount - 1).IsChecked = False
            Next I
            RowsCount = RowsCount + 1
        End If
    Loop
    Close (1)
    
    bAllChecked = False
    MegaGridCtrl.RowsCount = RowsCount
    MegaGridCtrl.ColumnsCount = UBound(ColumnsArray) + 1
    
    For I = 0 To UBound(ColumnsArray)
        Line_2 = ""
        Line_3 = ""
        Line_4 = ""
        If (I = 4) Then
            Line_2 = "Nickname"
        End If
        Result = MegaGridCtrl.ConfigureColumn(I, _
                                                ColumnsArray(I).Width, _
                                                ColumnsArray(I).Title, _
                                                Line_2, _
                                                Line_3, _
                                                Line_4, _
                                                -1, _
                                                -1, _
                                                ColumnsArray(I).Alignment, _
                                                True, _
                                                0)
    Next I
    
    For I = 0 To UBound(RowsArray)
        Call MegaGridCtrl.ConfigureRow(I + 1, 2001 + I, True, -1)
        For J = 0 To UBound(ColumnsArray)
            CellColor = -1
            TextColor = -1
            IsLinkText_1 = False
            
            If (I = 1) And (J = 3) Then
                'Customize this cell in terms of background color, text color, and link text
                CellColor = vbCyan
                TextColor = vbBlue
                IsLinkText_1 = True
            End If
            
            'Handle the cell text
            Line_2 = ""
            Line_3 = ""
            Line_4 = ""
            If (J = 4) Then
                Line_2 = "N/A"
                IsLinkText_2 = False
                If (RowsArray(I).CellsArray(J).Text = "Alaska") Then
                    Line_2 = "Last Frontier"
                    IsLinkText_4 = True
                ElseIf (RowsArray(I).CellsArray(J).Text = "Nunavut") Then
                    Line_2 = "The Land of the Midnight Sun"
                    IsLinkText_2 = True
                End If
            End If
            Result = MegaGridCtrl.ConfigureCellText(I + 1, _
                                                    J, _
                                                    RowsArray(I).CellsArray(J).Text, _
                                                    IsLinkText_1, _
                                                    Line_2, _
                                                    IsLinkText_2, _
                                                    Line_3, _
                                                    False, _
                                                    Line_4, _
                                                    False, _
                                                    CellColor, _
                                                    TextColor, _
                                                    ColumnsArray(J).Alignment)
                                                
            If (J = 5) Then
                'Handle the image
                Result = MegaGridCtrl.ConfigureCellImage(I + 1, _
                                                     J, _
                                                     0, _
                                                     App.Path + "\" + RowsArray(I).CellsArray(J).Text + ".bmp", _
                                                     20, _
                                                     15, _
                                                     4)
            End If
        Next J
    Next I
End Sub

Private Sub MegaGridCtrl_OnClickLink(ByVal RowIndex As Long, ByVal ColumnIndex As Long, ByVal RowTag As Long, ByVal LinkText As String)
    MsgBox ("You are clicking " + LinkText)
End Sub
