// DemoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "afxtempl.h"
#include "Demo.h"
#include "DemoDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

class Column : public CObject
{
public:
	int		Width;
	CString Title;
	int		Alignment; //0 - Left, 1 - Center, 2 - Right
};

class Row : public CObject
{
public:
	bool			IsChecked;
	CStringArray	CellsArray;
};


/////////////////////////////////////////////////////////////////////////////
// CDemoDlg dialog

CDemoDlg::CDemoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDemoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDemoDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDemoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDemoDlg)
	DDX_Control(pDX, IDC_BUTTON_ROW, m_BtnRow);
	DDX_Control(pDX, IDC_BUTTON_TAGS, m_BtnTags);
	DDX_Control(pDX, IDC_CHECK_ZEBRAS, m_ShowZebras);
	DDX_Control(pDX, IDC_CHECK_THICK, m_ThickLine);
	DDX_Control(pDX, IDC_CHECK_SHOW, m_ShowCheckBox);
	DDX_Control(pDX, IDC_MEGAGRIDCTRL, m_MegaGrid);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDemoDlg, CDialog)
	//{{AFX_MSG_MAP(CDemoDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_CHECK_SHOW, OnCheckShow)
	ON_BN_CLICKED(IDC_BUTTON_TAGS, OnButtonTags)
	ON_BN_CLICKED(IDC_CHECK_THICK, OnCheckThick)
	ON_BN_CLICKED(IDC_CHECK_ZEBRAS, OnCheckZebras)
	ON_BN_CLICKED(IDC_BUTTON_ROW, OnButtonRow)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDemoDlg message handlers

BOOL CDemoDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	try
	{
		char currDir[MAX_PATH];
		GetCurrentDirectory(MAX_PATH, currDir);

		CArray<Column *, Column *> ColumnsArray;
		CArray<Row *, Row *> RowsArray;

		int ColWidthArr[6];
		int ColAlignArr[6];
		ColWidthArr[0] = 45;
		ColWidthArr[1] = 80;
		ColWidthArr[2] = 80;
		ColWidthArr[3] = 95;
		ColWidthArr[4] = 120;
		ColWidthArr[5] = 100;
    
		ColAlignArr[0] = 2;
		ColAlignArr[1] = 1;
		ColAlignArr[2] = 1;
		ColAlignArr[3] = 1;
		ColAlignArr[4] = 1;
		ColAlignArr[5] = 0;

		CString strLine;
		char txtFilePath[MAX_PATH];
		strcpy(txtFilePath, currDir);
		strcat(txtFilePath, "\\Misc\\Cities.txt");
		CStdioFile file(txtFilePath, CFile::modeRead);
		CString field;
		int index;
		int RowsCount = 0;
		while (file.ReadString(strLine))
		{
			CArray<CString, CString> v;
			
			index = 0;
			while (AfxExtractSubString(field, strLine, index, '|'))
			{
				field.Remove(' ');
				v.Add(CString(field));
				index++;
			}

			if (RowsCount == 0) 
			{
				for (int i = 0; i < v.GetSize(); i++)
				{
					Column *objCol = new Column();
					objCol->Alignment	= ColAlignArr[i];
					objCol->Title		= v.GetAt(i);
					objCol->Width		= ColWidthArr[i];
					ColumnsArray.Add(objCol);
				}
				RowsCount = RowsCount + 1;
			}
			else
			{
				Row *objRow = new Row();
				objRow->IsChecked = true;
				for (int i = 0; i < v.GetSize(); i++)
				{
					objRow->CellsArray.Add(v.GetAt(i));
				}
				RowsArray.Add(objRow);
				RowsCount = RowsCount + 1;
			}
		}

		m_MegaGrid.SetRowsCount(RowsCount);
		m_MegaGrid.SetColumnsCount(ColumnsArray.GetSize());

		for(int i = 0; i < ColumnsArray.GetSize(); i++)
		{
			m_MegaGrid.ConfigureColumn(i,
										ColumnsArray.GetAt(i)->Width, 
										ColumnsArray.GetAt(i)->Title,
										"",
										"",
										"",
										-1,
										-1,
										ColumnsArray.GetAt(i)->Alignment,
										true,
										0);
		}

		for (i = 0; i < RowsArray.GetSize(); i++)
		{
			m_MegaGrid.ConfigureRow(i + 1, 2001 + i, true, -1);
			for (int j = 0; j < ColumnsArray.GetSize(); j++)
			{
				long CellColor = -1;
				long TextColor = -1;
				bool IsLinkText = false;

				if ((i == 1) && (j == 3))
				{
					//Customize this cell in terms of background color, text color, and link text
					CellColor = 0x00FF77;
					TextColor = 0x505050;
					IsLinkText = true;
				}

				//Handle the cell text
				m_MegaGrid.ConfigureCellText(i + 1,
											 j,
											 RowsArray.GetAt(i)->CellsArray.GetAt(j),
											 IsLinkText,
											 "",
											 false,
											 "",
											 false,
											 "",
											 false,
											 CellColor,
											 TextColor,
											 ColumnsArray.GetAt(j)->Alignment);

				if (j == 5)
				{
					//Handle the image
					char imgFilePath[MAX_PATH];
					strcpy(imgFilePath, currDir);
					strcat(imgFilePath, "\\Misc\\");
					strcat(imgFilePath, RowsArray.GetAt(i)->CellsArray.GetAt(j));
					strcat(imgFilePath, ".bmp");

					m_MegaGrid.ConfigureCellImage(i + 1,
												  j, 
												  0,
												  imgFilePath,
												  20,
												  15,
												  4);
				}
			}
		}

		for (i = 0; i < RowsArray.GetSize(); i++)
			delete RowsArray.GetAt(i);

		for (i = 0; i < ColumnsArray.GetSize(); i++)
			delete ColumnsArray.GetAt(i);

		m_ShowCheckBox.SetCheck(1);
		m_ThickLine.SetCheck(1);
		m_ShowZebras.SetCheck(1);
	}
	catch(CException e)
	{
	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDemoDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDemoDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CDemoDlg::OnOK() 
{
	// TODO: Add extra validation here
	CDialog::OnOK();
}

void CDemoDlg::OnCheckShow() 
{
	// TODO: Add your control notification handler code here
	if (m_ShowCheckBox.GetCheck())
	{
		m_ThickLine.EnableWindow(TRUE);
		m_BtnTags.EnableWindow(TRUE);
		m_MegaGrid.SetAllowCheckBox(TRUE);
	}
	else
	{
		m_ThickLine.EnableWindow(FALSE);
		m_BtnTags.EnableWindow(FALSE);
		m_MegaGrid.SetAllowCheckBox(FALSE);
	}
}

void CDemoDlg::OnButtonTags() 
{
	// TODO: Add your control notification handler code here
	int count = m_MegaGrid.GetCheckedRowsCount();
	CString strTags = "";
	char buf[100];
	for (int i = 0; i < count; i++)
	{
		int currTag = m_MegaGrid.GetCheckedRowTagAt(i);
		itoa(currTag, buf, 10);
		strTags = strTags + buf + " ";
	}
}

void CDemoDlg::OnButtonRow() 
{
	// TODO: Add your control notification handler code here
	int RowIndex = m_MegaGrid.GetSelectedRowIndex();
	int RowTag = m_MegaGrid.GetSelectedRowTag();
}

void CDemoDlg::OnCheckThick() 
{
	// TODO: Add your control notification handler code here
	if (m_ThickLine.GetCheck())
		m_MegaGrid.SetCheckThickLine(true);
	else
		m_MegaGrid.SetCheckThickLine(false);	
}

void CDemoDlg::OnCheckZebras() 
{
	// TODO: Add your control notification handler code here
	if (m_ShowZebras.GetCheck())
		m_MegaGrid.SetAllowZebras(TRUE);
	else
		m_MegaGrid.SetAllowZebras(FALSE);
}

BEGIN_EVENTSINK_MAP(CDemoDlg, CDialog)
    //{{AFX_EVENTSINK_MAP(CDemoDlg)
	ON_EVENT(CDemoDlg, IDC_MEGAGRIDCTRL, 20 /* OnClickLink */, OnOnClickLinkMegagridctrl, VTS_I4 VTS_I4 VTS_BSTR)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()

void CDemoDlg::OnOnClickLinkMegagridctrl(long RowIndex, long ColumnIndex, LPCTSTR LinkText) 
{
	// TODO: Add your control notification handler code here
	CString msg = "You are clicking ";
	msg += LinkText;
	AfxMessageBox(msg); 
}


