using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Drawing.Imaging;
using System.IO;
using MW6.LogoQRCode;

namespace Demo
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class frmDemo : System.Windows.Forms.Form
	{
		internal System.Windows.Forms.Button btnExit;
		private System.Windows.Forms.GroupBox groupBox1;
		internal System.Windows.Forms.TextBox txtData;
		internal System.Windows.Forms.Label lblData;
		private QRCode QRNetLib;
		private System.Windows.Forms.Button btnGenQRCode;
		private PictureBox pbxQRCode;
		internal TextBox txtHeight;
		internal Label lblHeight;
		internal TextBox txtWidth;
		internal Label lblWidth;
		internal Label lblBackColor;
		internal Label lblBackColorHolder;
		internal Button btnChooseBackColor;
		internal Button btnChooseQRColor;
		internal Label lblQRColorHolder;
		internal Label lblQRColor;
		private ComboBox cbxMarker;
		private Label lblMarker;
		private ComboBox cbxDots;
		private Label lblDots;
		private ComboBox cbxGradient;
		private Label lblGradient;
		internal Button btnChooseEndColor;
		internal Label lblEndColorHolder;
		internal Label lblEndColor;
		internal Button btnChooseStartColor;
		internal Label lblStartColorHolder;
		internal Label lblStartColor;
		private ComboBox cbxLogoSize;
		private Label lblLogoSize;
		private Label lblLogo;
		internal Button btnChooseLogo;
		private PictureBox pbxLogo;
		private ColorDialog cdgSelectColor;
		private OpenFileDialog ofdSelectImage;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public frmDemo()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.btnExit = new System.Windows.Forms.Button();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.btnChooseLogo = new System.Windows.Forms.Button();
			this.pbxLogo = new System.Windows.Forms.PictureBox();
			this.lblLogo = new System.Windows.Forms.Label();
			this.cbxLogoSize = new System.Windows.Forms.ComboBox();
			this.lblLogoSize = new System.Windows.Forms.Label();
			this.btnChooseEndColor = new System.Windows.Forms.Button();
			this.lblEndColorHolder = new System.Windows.Forms.Label();
			this.lblEndColor = new System.Windows.Forms.Label();
			this.btnChooseStartColor = new System.Windows.Forms.Button();
			this.lblStartColorHolder = new System.Windows.Forms.Label();
			this.lblStartColor = new System.Windows.Forms.Label();
			this.cbxGradient = new System.Windows.Forms.ComboBox();
			this.lblGradient = new System.Windows.Forms.Label();
			this.cbxDots = new System.Windows.Forms.ComboBox();
			this.lblDots = new System.Windows.Forms.Label();
			this.cbxMarker = new System.Windows.Forms.ComboBox();
			this.lblMarker = new System.Windows.Forms.Label();
			this.btnChooseQRColor = new System.Windows.Forms.Button();
			this.lblQRColorHolder = new System.Windows.Forms.Label();
			this.lblQRColor = new System.Windows.Forms.Label();
			this.btnChooseBackColor = new System.Windows.Forms.Button();
			this.lblBackColorHolder = new System.Windows.Forms.Label();
			this.lblBackColor = new System.Windows.Forms.Label();
			this.txtHeight = new System.Windows.Forms.TextBox();
			this.lblHeight = new System.Windows.Forms.Label();
			this.txtWidth = new System.Windows.Forms.TextBox();
			this.lblWidth = new System.Windows.Forms.Label();
			this.txtData = new System.Windows.Forms.TextBox();
			this.lblData = new System.Windows.Forms.Label();
			this.btnGenQRCode = new System.Windows.Forms.Button();
			this.pbxQRCode = new System.Windows.Forms.PictureBox();
			this.cdgSelectColor = new System.Windows.Forms.ColorDialog();
			this.ofdSelectImage = new System.Windows.Forms.OpenFileDialog();
			this.groupBox1.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.pbxLogo)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.pbxQRCode)).BeginInit();
			this.SuspendLayout();
			// 
			// btnExit
			// 
			this.btnExit.Location = new System.Drawing.Point(631, 20);
			this.btnExit.Name = "btnExit";
			this.btnExit.Size = new System.Drawing.Size(120, 32);
			this.btnExit.TabIndex = 2;
			this.btnExit.Text = "Close";
			this.btnExit.Click += new System.EventHandler(this.btnExit_Click);
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.Add(this.btnChooseLogo);
			this.groupBox1.Controls.Add(this.pbxLogo);
			this.groupBox1.Controls.Add(this.lblLogo);
			this.groupBox1.Controls.Add(this.cbxLogoSize);
			this.groupBox1.Controls.Add(this.lblLogoSize);
			this.groupBox1.Controls.Add(this.btnChooseEndColor);
			this.groupBox1.Controls.Add(this.lblEndColorHolder);
			this.groupBox1.Controls.Add(this.lblEndColor);
			this.groupBox1.Controls.Add(this.btnChooseStartColor);
			this.groupBox1.Controls.Add(this.lblStartColorHolder);
			this.groupBox1.Controls.Add(this.lblStartColor);
			this.groupBox1.Controls.Add(this.cbxGradient);
			this.groupBox1.Controls.Add(this.lblGradient);
			this.groupBox1.Controls.Add(this.cbxDots);
			this.groupBox1.Controls.Add(this.lblDots);
			this.groupBox1.Controls.Add(this.cbxMarker);
			this.groupBox1.Controls.Add(this.lblMarker);
			this.groupBox1.Controls.Add(this.btnChooseQRColor);
			this.groupBox1.Controls.Add(this.lblQRColorHolder);
			this.groupBox1.Controls.Add(this.lblQRColor);
			this.groupBox1.Controls.Add(this.btnChooseBackColor);
			this.groupBox1.Controls.Add(this.lblBackColorHolder);
			this.groupBox1.Controls.Add(this.lblBackColor);
			this.groupBox1.Controls.Add(this.txtHeight);
			this.groupBox1.Controls.Add(this.lblHeight);
			this.groupBox1.Controls.Add(this.txtWidth);
			this.groupBox1.Controls.Add(this.lblWidth);
			this.groupBox1.Controls.Add(this.txtData);
			this.groupBox1.Controls.Add(this.lblData);
			this.groupBox1.Location = new System.Drawing.Point(16, 8);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(396, 390);
			this.groupBox1.TabIndex = 0;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Settings";
			// 
			// btnChooseLogo
			// 
			this.btnChooseLogo.Location = new System.Drawing.Point(190, 321);
			this.btnChooseLogo.Name = "btnChooseLogo";
			this.btnChooseLogo.Size = new System.Drawing.Size(80, 20);
			this.btnChooseLogo.TabIndex = 11;
			this.btnChooseLogo.Text = "Choose";
			this.btnChooseLogo.Click += new System.EventHandler(this.btnChooseLogo_Click);
			// 
			// pbxLogo
			// 
			this.pbxLogo.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.pbxLogo.Location = new System.Drawing.Point(100, 322);
			this.pbxLogo.Name = "pbxLogo";
			this.pbxLogo.Size = new System.Drawing.Size(56, 56);
			this.pbxLogo.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.pbxLogo.TabIndex = 106;
			this.pbxLogo.TabStop = false;
			// 
			// lblLogo
			// 
			this.lblLogo.AutoSize = true;
			this.lblLogo.Location = new System.Drawing.Point(66, 321);
			this.lblLogo.Name = "lblLogo";
			this.lblLogo.Size = new System.Drawing.Size(31, 13);
			this.lblLogo.TabIndex = 105;
			this.lblLogo.Text = "Logo";
			// 
			// cbxLogoSize
			// 
			this.cbxLogoSize.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.cbxLogoSize.FormattingEnabled = true;
			this.cbxLogoSize.Items.AddRange(new object[] {
            "Extra Small",
            "Small",
            "Medium",
            "Large",
            "Extra Large"});
			this.cbxLogoSize.Location = new System.Drawing.Point(99, 291);
			this.cbxLogoSize.Name = "cbxLogoSize";
			this.cbxLogoSize.Size = new System.Drawing.Size(171, 21);
			this.cbxLogoSize.TabIndex = 10;
			// 
			// lblLogoSize
			// 
			this.lblLogoSize.AutoSize = true;
			this.lblLogoSize.Location = new System.Drawing.Point(43, 295);
			this.lblLogoSize.Name = "lblLogoSize";
			this.lblLogoSize.Size = new System.Drawing.Size(54, 13);
			this.lblLogoSize.TabIndex = 103;
			this.lblLogoSize.Text = "Logo Size";
			// 
			// btnChooseEndColor
			// 
			this.btnChooseEndColor.Location = new System.Drawing.Point(190, 264);
			this.btnChooseEndColor.Name = "btnChooseEndColor";
			this.btnChooseEndColor.Size = new System.Drawing.Size(80, 20);
			this.btnChooseEndColor.TabIndex = 9;
			this.btnChooseEndColor.Text = "Choose";
			this.btnChooseEndColor.Click += new System.EventHandler(this.btnChooseEndColor_Click);
			// 
			// lblEndColorHolder
			// 
			this.lblEndColorHolder.BackColor = System.Drawing.Color.Red;
			this.lblEndColorHolder.Location = new System.Drawing.Point(99, 264);
			this.lblEndColorHolder.Name = "lblEndColorHolder";
			this.lblEndColorHolder.Size = new System.Drawing.Size(76, 21);
			this.lblEndColorHolder.TabIndex = 102;
			this.lblEndColorHolder.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// lblEndColor
			// 
			this.lblEndColor.Location = new System.Drawing.Point(6, 266);
			this.lblEndColor.Name = "lblEndColor";
			this.lblEndColor.Size = new System.Drawing.Size(91, 16);
			this.lblEndColor.TabIndex = 101;
			this.lblEndColor.Text = "End Color";
			this.lblEndColor.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// btnChooseStartColor
			// 
			this.btnChooseStartColor.Location = new System.Drawing.Point(190, 238);
			this.btnChooseStartColor.Name = "btnChooseStartColor";
			this.btnChooseStartColor.Size = new System.Drawing.Size(80, 20);
			this.btnChooseStartColor.TabIndex = 8;
			this.btnChooseStartColor.Text = "Choose";
			this.btnChooseStartColor.Click += new System.EventHandler(this.btnChooseStartColor_Click);
			// 
			// lblStartColorHolder
			// 
			this.lblStartColorHolder.BackColor = System.Drawing.Color.DarkBlue;
			this.lblStartColorHolder.Location = new System.Drawing.Point(99, 238);
			this.lblStartColorHolder.Name = "lblStartColorHolder";
			this.lblStartColorHolder.Size = new System.Drawing.Size(76, 21);
			this.lblStartColorHolder.TabIndex = 99;
			this.lblStartColorHolder.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// lblStartColor
			// 
			this.lblStartColor.Location = new System.Drawing.Point(11, 240);
			this.lblStartColor.Name = "lblStartColor";
			this.lblStartColor.Size = new System.Drawing.Size(86, 16);
			this.lblStartColor.TabIndex = 98;
			this.lblStartColor.Text = "Start Color";
			this.lblStartColor.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// cbxGradient
			// 
			this.cbxGradient.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.cbxGradient.FormattingEnabled = true;
			this.cbxGradient.Items.AddRange(new object[] {
            "None",
            "From Left To Right",
            "From Top To Bottom",
            "From Top Left To Bottom Right",
            "From Bottom Left To Top Right",
            "Radial"});
			this.cbxGradient.Location = new System.Drawing.Point(99, 156);
			this.cbxGradient.Name = "cbxGradient";
			this.cbxGradient.Size = new System.Drawing.Size(171, 21);
			this.cbxGradient.TabIndex = 5;
			this.cbxGradient.SelectedIndexChanged += new System.EventHandler(this.cbxGradient_SelectedIndexChanged);
			// 
			// lblGradient
			// 
			this.lblGradient.AutoSize = true;
			this.lblGradient.Location = new System.Drawing.Point(50, 160);
			this.lblGradient.Name = "lblGradient";
			this.lblGradient.Size = new System.Drawing.Size(47, 13);
			this.lblGradient.TabIndex = 95;
			this.lblGradient.Text = "Gradient";
			// 
			// cbxDots
			// 
			this.cbxDots.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.cbxDots.FormattingEnabled = true;
			this.cbxDots.Items.AddRange(new object[] {
            "1",
            "2",
            "3",
            "4",
            "5",
            "6",
            "7"});
			this.cbxDots.Location = new System.Drawing.Point(99, 129);
			this.cbxDots.Name = "cbxDots";
			this.cbxDots.Size = new System.Drawing.Size(61, 21);
			this.cbxDots.TabIndex = 4;
			// 
			// lblDots
			// 
			this.lblDots.AutoSize = true;
			this.lblDots.Location = new System.Drawing.Point(68, 133);
			this.lblDots.Name = "lblDots";
			this.lblDots.Size = new System.Drawing.Size(29, 13);
			this.lblDots.TabIndex = 93;
			this.lblDots.Text = "Dots";
			// 
			// cbxMarker
			// 
			this.cbxMarker.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.cbxMarker.FormattingEnabled = true;
			this.cbxMarker.Items.AddRange(new object[] {
            "1",
            "2",
            "3",
            "4",
            "5",
            "6",
            "7",
            "8",
            "9",
            "10",
            "11",
            "12",
            "13",
            "14",
            "15",
            "16",
            "17"});
			this.cbxMarker.Location = new System.Drawing.Point(99, 102);
			this.cbxMarker.Name = "cbxMarker";
			this.cbxMarker.Size = new System.Drawing.Size(61, 21);
			this.cbxMarker.TabIndex = 3;
			// 
			// lblMarker
			// 
			this.lblMarker.AutoSize = true;
			this.lblMarker.Location = new System.Drawing.Point(57, 106);
			this.lblMarker.Name = "lblMarker";
			this.lblMarker.Size = new System.Drawing.Size(40, 13);
			this.lblMarker.TabIndex = 91;
			this.lblMarker.Text = "Marker";
			// 
			// btnChooseQRColor
			// 
			this.btnChooseQRColor.Location = new System.Drawing.Point(190, 210);
			this.btnChooseQRColor.Name = "btnChooseQRColor";
			this.btnChooseQRColor.Size = new System.Drawing.Size(80, 20);
			this.btnChooseQRColor.TabIndex = 7;
			this.btnChooseQRColor.Text = "Choose";
			this.btnChooseQRColor.Click += new System.EventHandler(this.btnChooseQRColor_Click);
			// 
			// lblQRColorHolder
			// 
			this.lblQRColorHolder.BackColor = System.Drawing.Color.Black;
			this.lblQRColorHolder.Location = new System.Drawing.Point(99, 211);
			this.lblQRColorHolder.Name = "lblQRColorHolder";
			this.lblQRColorHolder.Size = new System.Drawing.Size(76, 21);
			this.lblQRColorHolder.TabIndex = 90;
			this.lblQRColorHolder.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// lblQRColor
			// 
			this.lblQRColor.Location = new System.Drawing.Point(17, 212);
			this.lblQRColor.Name = "lblQRColor";
			this.lblQRColor.Size = new System.Drawing.Size(80, 16);
			this.lblQRColor.TabIndex = 89;
			this.lblQRColor.Text = "QRCode Color";
			this.lblQRColor.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// btnChooseBackColor
			// 
			this.btnChooseBackColor.Location = new System.Drawing.Point(190, 183);
			this.btnChooseBackColor.Name = "btnChooseBackColor";
			this.btnChooseBackColor.Size = new System.Drawing.Size(80, 20);
			this.btnChooseBackColor.TabIndex = 6;
			this.btnChooseBackColor.Text = "Choose";
			this.btnChooseBackColor.Click += new System.EventHandler(this.btnChooseBackColor_Click);
			// 
			// lblBackColorHolder
			// 
			this.lblBackColorHolder.BackColor = System.Drawing.Color.White;
			this.lblBackColorHolder.Location = new System.Drawing.Point(99, 183);
			this.lblBackColorHolder.Name = "lblBackColorHolder";
			this.lblBackColorHolder.Size = new System.Drawing.Size(76, 21);
			this.lblBackColorHolder.TabIndex = 87;
			this.lblBackColorHolder.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// lblBackColor
			// 
			this.lblBackColor.Location = new System.Drawing.Point(1, 185);
			this.lblBackColor.Name = "lblBackColor";
			this.lblBackColor.Size = new System.Drawing.Size(96, 17);
			this.lblBackColor.TabIndex = 86;
			this.lblBackColor.Text = "Background Color";
			this.lblBackColor.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// txtHeight
			// 
			this.txtHeight.Location = new System.Drawing.Point(99, 48);
			this.txtHeight.Name = "txtHeight";
			this.txtHeight.Size = new System.Drawing.Size(56, 20);
			this.txtHeight.TabIndex = 1;
			this.txtHeight.Text = "200";
			// 
			// lblHeight
			// 
			this.lblHeight.Location = new System.Drawing.Point(49, 50);
			this.lblHeight.Name = "lblHeight";
			this.lblHeight.Size = new System.Drawing.Size(48, 16);
			this.lblHeight.TabIndex = 85;
			this.lblHeight.Text = "Height";
			this.lblHeight.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// txtWidth
			// 
			this.txtWidth.Location = new System.Drawing.Point(99, 21);
			this.txtWidth.Name = "txtWidth";
			this.txtWidth.Size = new System.Drawing.Size(56, 20);
			this.txtWidth.TabIndex = 0;
			this.txtWidth.Text = "200";
			// 
			// lblWidth
			// 
			this.lblWidth.Location = new System.Drawing.Point(57, 22);
			this.lblWidth.Name = "lblWidth";
			this.lblWidth.Size = new System.Drawing.Size(40, 16);
			this.lblWidth.TabIndex = 82;
			this.lblWidth.Text = "Width";
			this.lblWidth.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// txtData
			// 
			this.txtData.Location = new System.Drawing.Point(99, 75);
			this.txtData.Name = "txtData";
			this.txtData.Size = new System.Drawing.Size(289, 20);
			this.txtData.TabIndex = 2;
			this.txtData.Text = "https://www.mw6tech.com";
			// 
			// lblData
			// 
			this.lblData.Location = new System.Drawing.Point(60, 77);
			this.lblData.Name = "lblData";
			this.lblData.Size = new System.Drawing.Size(37, 16);
			this.lblData.TabIndex = 81;
			this.lblData.Text = "Data";
			this.lblData.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// btnGenQRCode
			// 
			this.btnGenQRCode.Location = new System.Drawing.Point(488, 20);
			this.btnGenQRCode.Name = "btnGenQRCode";
			this.btnGenQRCode.Size = new System.Drawing.Size(120, 32);
			this.btnGenQRCode.TabIndex = 1;
			this.btnGenQRCode.Text = "Generate QRCode";
			this.btnGenQRCode.Click += new System.EventHandler(this.btnGenQRCode_Click);
			// 
			// pbxQRCode
			// 
			this.pbxQRCode.Location = new System.Drawing.Point(432, 71);
			this.pbxQRCode.Name = "pbxQRCode";
			this.pbxQRCode.Size = new System.Drawing.Size(370, 342);
			this.pbxQRCode.TabIndex = 9;
			this.pbxQRCode.TabStop = false;
			// 
			// ofdSelectImage
			// 
			this.ofdSelectImage.FileName = "openFileDialog1";
			this.ofdSelectImage.Filter = "Image Files|*.bmp; *.jpg;*.jpeg;*.png;*.gif;*.tif";
			// 
			// frmDemo
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(814, 437);
			this.Controls.Add(this.pbxQRCode);
			this.Controls.Add(this.btnGenQRCode);
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.btnExit);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "frmDemo";
			this.Text = "Demo for LogoQRCode .NET Library";
			this.Load += new System.EventHandler(this.frmDemo_Load);
			this.groupBox1.ResumeLayout(false);
			this.groupBox1.PerformLayout();
			((System.ComponentModel.ISupportInitialize)(this.pbxLogo)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.pbxQRCode)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new frmDemo());
		}

		private void frmDemo_Load(object sender, System.EventArgs e)
		{
			cbxDots.SelectedIndex		= 0;
			cbxMarker.SelectedIndex		= 0;
			cbxGradient.SelectedIndex	= 0;
			cbxLogoSize.SelectedIndex	= 1;
		}

		private void cbxGradient_SelectedIndexChanged(object sender, EventArgs e)
		{
			bool bSolidColor = (cbxGradient.SelectedIndex == 0);

			//Change UI a bit
			lblQRColor.Enabled			= bSolidColor;
			lblBackColorHolder.Enabled	= bSolidColor;
			btnChooseQRColor.Enabled	= bSolidColor;

			lblStartColor.Enabled		= !bSolidColor;
			lblStartColorHolder.Enabled = !bSolidColor;
			btnChooseStartColor.Enabled = !bSolidColor;

			lblEndColor.Enabled			= !bSolidColor;
			lblEndColorHolder.Enabled	= !bSolidColor;
			btnChooseEndColor.Enabled	= !bSolidColor;
		}

		private void btnChooseBackColor_Click(object sender, EventArgs e)
		{
			//Choose background color
			cdgSelectColor.Color = lblBackColorHolder.BackColor;
			if (cdgSelectColor.ShowDialog() == DialogResult.OK)
				lblBackColorHolder.BackColor = cdgSelectColor.Color;
		}

		private void btnChooseQRColor_Click(object sender, EventArgs e)
		{
			//Choose QRCode color
			cdgSelectColor.Color = lblQRColorHolder.BackColor;
			if (cdgSelectColor.ShowDialog() == DialogResult.OK)
				lblQRColorHolder.BackColor = cdgSelectColor.Color;
		}

		private void btnChooseStartColor_Click(object sender, EventArgs e)
		{
			//Choose start color for gradient drawing
			cdgSelectColor.Color = lblStartColorHolder.BackColor;
			if (cdgSelectColor.ShowDialog() == DialogResult.OK)
				lblStartColorHolder.BackColor = cdgSelectColor.Color;
		}

		private void btnChooseEndColor_Click(object sender, EventArgs e)
		{
			//Choose end color for gradient drawing
			cdgSelectColor.Color = lblEndColorHolder.BackColor;
			if (cdgSelectColor.ShowDialog() == DialogResult.OK)
				lblEndColorHolder.BackColor = cdgSelectColor.Color;
		}

		private void btnChooseLogo_Click(object sender, EventArgs e)
		{
			//Choose logo image
			if (ofdSelectImage.ShowDialog() == DialogResult.OK)
				pbxLogo.Image = Image.FromFile(ofdSelectImage.FileName);
		}

		private void btnGenQRCode_Click(object sender, EventArgs e)
		{
			QRNetLib = new QRCode();

			//Configure QRCode
			QRNetLib.SetSize(Convert.ToInt16(txtWidth.Text), Convert.ToInt16(txtHeight.Text));
			
			QRNetLib.Data			= txtData.Text;
			QRNetLib.Logo			= pbxLogo.Image;
			QRNetLib.BackColor		= lblBackColorHolder.BackColor;
			
			QRNetLib.DotsOption		= cbxDots.SelectedIndex + 1;
			QRNetLib.MarkerOption	= cbxMarker.SelectedIndex + 1;
			QRNetLib.GradientOption = (enumGradient)(cbxGradient.SelectedIndex + 1);
			if (cbxGradient.SelectedIndex == 0)
			{
				//Solid drawing
				QRNetLib.BarColor	= lblQRColorHolder.BackColor;
			}
			else
			{
				//Gradient drawing
				QRNetLib.StartColor = lblStartColorHolder.BackColor;
				QRNetLib.EndColor	= lblEndColorHolder.BackColor;
			}

			//Logo size
			QRNetLib.LogoSizeOpt	= (enumLogoSize)(cbxLogoSize.SelectedIndex + 1);
			
			//Logo image
			QRNetLib.Logo			= pbxLogo.Image;

			//Display QRCode in a PictureBox
			MemoryStream MS = new MemoryStream();			
			QRNetLib.SaveAsMemory(MS, ImageFormat.Jpeg);
			pbxQRCode.Height = Convert.ToInt16(txtWidth.Text);
			pbxQRCode.Width = Convert.ToInt16(txtHeight.Text);
			pbxQRCode.Image = Image.FromStream(MS);
		}

		private void btnExit_Click(object sender, System.EventArgs e)
		{
			Application.Exit(); 
		}
	}
}