Attribute VB_Name = "IT25"
' VB / VBA Functions for Interleaved25
' Copyright 2005 by MW6 Technologies Inc. All rights reserved.
'
' This code may not be modified or distributed unless you purchase
' the license from MW6.

Private I As Integer
Private StrLen As Integer
Private Sum As Integer
Private CurrChar As Integer
Private Message As String
Private Weight  As Integer
Private Tmp As String

Public Function IT25Encode(ByVal Src As String, ByVal CheckDigit As Boolean) As String
    StrLen = Len(Src)
    
    If (CheckDigit) Then
        Sum = 0
        Weight = 3
        For I = 1 To StrLen
            CurrChar = Asc(Mid(Src, StrLen + 1 - I, 1)) - Asc("0")
            Sum = Sum + CurrChar * Weight
            Weight = 4 - Weight
        Next I
        
        Sum = Sum Mod 10
        If (Sum <> 0) Then
            Sum = 10 - Sum
        End If
        
        Tmp = Src & Chr(Sum + Asc("0"))
        If ((Len(Tmp) Mod 2) = 1) Then
            Tmp = "0" & Tmp
        End If
    Else
        If ((StrLen Mod 2) = 1) Then
            Tmp = "0" & Src
        Else
            Tmp = Src
        End If
    End If
        
    StrLen = Len(Tmp)
    
    ' start character (198)
    Message = "" & Chr(198)
    I = 1
    While (I < StrLen)
        Sum = Asc(Mid(Tmp, I, 1)) - Asc("0")
        Sum = 10 * Sum + Asc(Mid(Tmp, I + 1, 1)) - Asc("0")
        If (Sum < 94) Then
            Message = Message & Chr(Sum + 33)
        Else
            Message = Message & Chr(Sum + 98)
        End If
        
        I = I + 2
    Wend
    
    ' stop character (199)
    Message = Message & Chr(199)
    
    IT25Encode = Message
End Function

